import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DownChartsIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <circle cx={8} cy={8} r={8} fill={props.fill} />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.25014 7.70355L9.19004 5.98416L9.19124 5.98346C9.34293 5.89616 9.51861 5.8739 9.68452 5.91946C9.85198 5.96545 9.99369 6.07399 10.0776 6.22947L10.0834 6.24018L11.5683 10.029L12.0784 8.1715C12.1737 7.82426 12.5291 7.61291 12.8763 7.70827C13.2244 7.80386 13.4201 8.17065 13.3258 8.51405L12.3581 12.0383C12.2623 12.3869 11.907 12.5953 11.5588 12.5044L11.5564 12.5037L8.1095 11.5572C7.7614 11.4616 7.56571 11.0948 7.66001 10.7514C7.75537 10.4041 8.11071 10.1928 8.45798 10.2882L10.4716 10.8411L9.23168 7.46716L6.29772 9.18308L6.29652 9.18378C6.14483 9.27108 5.96915 9.29333 5.80324 9.24777C5.63379 9.20124 5.4973 9.09274 5.41182 8.94084L5.40598 8.93046L3.71995 4.87006C3.66388 4.76154 3.61759 4.5929 3.67612 4.37974C3.72145 4.21466 3.82055 4.07534 3.97264 3.98789M6.25014 7.70355L4.8638 4.24231L4.85734 4.23083C4.77186 4.07893 4.63537 3.97042 4.46592 3.92389C4.30005 3.87834 4.1243 3.90064 3.97264 3.98789"
            fill="white"
        />
    </svg>
);

DownChartsIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default DownChartsIcon;
