import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DryCleaningIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.4878 4.25252C10.4838 2.77886 9.36744 1.74388 8.01413 1.71476C6.69714 1.68642 5.50771 2.80731 5.50771 4.17975C5.50771 4.59136 5.84475 4.92504 6.26052 4.92504C6.67628 4.92504 7.01333 4.59136 7.01333 4.17975C7.01333 3.65261 7.49934 3.1946 7.98141 3.20497C8.54459 3.2171 8.98048 3.62121 8.98222 4.25654C8.98326 4.63977 8.66925 5.02619 7.90211 5.42136C7.49972 5.62865 7.24728 6.0404 7.24728 6.48948L7.24742 7.22464C7.24742 7.87103 7.62586 8.45883 8.21773 8.73174L12.1978 10.5248C12.4771 10.6408 12.6013 10.8131 12.5777 10.9695C12.5462 11.1776 12.2718 11.4312 12.164 11.4312H3.83701C3.72483 11.4312 3.45577 11.1839 3.42337 10.9695C3.39889 10.8075 3.5182 10.6432 3.77531 10.537L6.0071 9.51399C6.3826 9.33727 6.54229 8.89265 6.36378 8.52091C6.18528 8.14917 5.73617 7.99107 5.36067 8.16779L1.5345 9.96852C0.726308 10.3015 0.168723 11.0694 0.306685 11.9825C0.446038 12.9047 1.32689 13.7142 2.20938 13.7142H13.7911C14.6712 13.7142 15.5556 12.8968 15.6938 11.9825C15.8305 11.0778 15.2698 10.2997 14.4327 9.95384L8.85341 7.38054C8.79218 7.35231 8.75304 7.2915 8.75304 7.22464V6.66055C9.87198 6.04372 10.4905 5.23942 10.4878 4.25252Z"
            fill={props.fill}
        />
    </svg>
);

DryCleaningIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default DryCleaningIcon;
