import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const EntertainmentIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 18"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M13.278 6.50196H2.72197C1.99958 6.50333 1.30725 6.79126 0.796931 7.30256C0.286611 7.81385 -1.30548e-06 8.50673 0 9.22911V13.351C0.0643081 14.0597 0.391323 14.7188 0.916803 15.1988C1.44228 15.6788 2.12824 15.9449 2.83992 15.9449C3.5516 15.9449 4.23756 15.6788 4.76304 15.1988C5.28852 14.7188 5.61554 14.0597 5.67984 13.351V12.4307C5.67984 12.3963 5.6935 12.3633 5.71781 12.339C5.74212 12.3147 5.77509 12.3011 5.80946 12.3011H10.1905C10.2249 12.3011 10.2579 12.3147 10.2822 12.339C10.3065 12.3633 10.3202 12.3963 10.3202 12.4307V13.3458C10.3845 14.0545 10.7115 14.7136 11.237 15.1936C11.7624 15.6736 12.4484 15.9397 13.1601 15.9397C13.8718 15.9397 14.5577 15.6736 15.0832 15.1936C15.6087 14.7136 15.9357 14.0545 16 13.3458V9.22911C16 8.50673 15.7134 7.81385 15.2031 7.30256C14.6927 6.79126 14.0004 6.50333 13.278 6.50196ZM3.05898 11.0982C2.77174 11.0982 2.49097 11.013 2.25218 10.8534C2.01339 10.6937 1.82732 10.4668 1.71752 10.2014C1.60772 9.93601 1.57912 9.64399 1.63535 9.36231C1.69157 9.08064 1.83009 8.82197 2.03338 8.61905C2.23666 8.41612 2.49558 8.27807 2.77735 8.22234C3.05913 8.16662 3.3511 8.19574 3.61632 8.30602C3.88154 8.41629 4.10809 8.60277 4.2673 8.84184C4.4265 9.08091 4.51121 9.36184 4.51069 9.64908C4.51001 10.0336 4.35676 10.4022 4.08458 10.6739C3.8124 10.9456 3.44355 11.0982 3.05898 11.0982ZM14.0039 10.0379H13.3299V10.7093C13.3299 10.8125 13.2889 10.9114 13.216 10.9843C13.1431 11.0572 13.0442 11.0982 12.941 11.0982C12.8379 11.0982 12.739 11.0572 12.6661 10.9843C12.5931 10.9114 12.5522 10.8125 12.5522 10.7093V10.0379H11.8885C11.7854 10.0379 11.6865 9.99696 11.6136 9.92404C11.5406 9.85111 11.4997 9.75221 11.4997 9.64908C11.4997 9.54595 11.5406 9.44704 11.6136 9.37412C11.6865 9.30119 11.7854 9.26022 11.8885 9.26022H12.5625V8.58621C12.5625 8.48308 12.6035 8.38417 12.6764 8.31125C12.7494 8.23833 12.8483 8.19736 12.9514 8.19736C13.0545 8.19736 13.1534 8.23833 13.2264 8.31125C13.2993 8.38417 13.3402 8.48308 13.3402 8.58621V9.26022H14.0143C14.1174 9.26022 14.2163 9.30119 14.2892 9.37412C14.3621 9.44704 14.4031 9.54595 14.4031 9.64908C14.4031 9.75221 14.3621 9.85111 14.2892 9.92404C14.2163 9.99696 14.1174 10.0379 14.0143 10.0379H14.0039ZM3.73299 9.64908C3.73299 9.78238 3.69346 9.9127 3.6194 10.0235C3.54533 10.1344 3.44007 10.2208 3.31691 10.2718C3.19375 10.3228 3.05823 10.3361 2.92748 10.3101C2.79674 10.2841 2.67664 10.2199 2.58238 10.1257C2.48812 10.0314 2.42392 9.91131 2.39792 9.78057C2.37191 9.64982 2.38526 9.5143 2.43627 9.39114C2.48728 9.26798 2.57367 9.16272 2.68452 9.08866C2.79536 9.01459 2.92567 8.97506 3.05898 8.97506C3.23774 8.97506 3.40917 9.04608 3.53557 9.17248C3.66198 9.29888 3.73299 9.47032 3.73299 9.64908ZM8.39922 5.72425H7.62152V4.49289C7.6222 4.0462 7.79995 3.618 8.11581 3.30215C8.43166 2.98629 8.85986 2.80854 9.30655 2.80786H10.7038C10.9445 2.80786 11.1752 2.71227 11.3454 2.54211C11.5156 2.37195 11.6111 2.14117 11.6111 1.90053V0.588804C11.6111 0.485674 11.6521 0.386768 11.725 0.313844C11.798 0.240919 11.8969 0.199951 12 0.199951C12.1031 0.199951 12.202 0.240919 12.275 0.313844C12.3479 0.386768 12.3889 0.485674 12.3889 0.588804V1.90053C12.3889 2.12182 12.3453 2.34093 12.2606 2.54537C12.1759 2.7498 12.0518 2.93556 11.8953 3.09203C11.7389 3.2485 11.5531 3.37262 11.3487 3.4573C11.1442 3.54198 10.9251 3.58556 10.7038 3.58556H9.29618C9.05575 3.58625 8.82537 3.68206 8.65536 3.85207C8.48535 4.02208 8.38954 4.25246 8.38885 4.49289L8.39922 5.72425Z"
            fill={props.fill}
        />
        <path
            d="M8.39923 5.82425H8.50007L8.49922 5.72341L8.48886 4.49317C8.48886 4.49299 8.48886 4.49281 8.48886 4.49263C8.48961 4.27882 8.57488 4.07397 8.72607 3.92278C8.87738 3.77147 9.08241 3.68619 9.29638 3.68556C9.29641 3.68556 9.29644 3.68556 9.29647 3.68556L10.7038 3.68556C10.9382 3.68556 11.1704 3.63939 11.3869 3.54969C11.6035 3.45998 11.8003 3.3285 11.966 3.16274C12.1318 2.99699 12.2633 2.8002 12.353 2.58364C12.4427 2.36707 12.4889 2.13495 12.4889 1.90053V0.588804C12.4889 0.459153 12.4374 0.334811 12.3457 0.243133C12.254 0.151455 12.1297 0.0999512 12 0.0999512C11.8704 0.0999512 11.746 0.151455 11.6543 0.243133C11.5627 0.334811 11.5112 0.459153 11.5112 0.588804V1.90053C11.5112 2.11465 11.4261 2.32 11.2747 2.4714C11.1233 2.6228 10.9179 2.70786 10.7038 2.70786L9.30655 2.70786L9.3064 2.70786C8.83324 2.70858 8.37967 2.89687 8.0451 3.23144C7.71053 3.56601 7.52225 4.01958 7.52152 4.49273V4.49289V5.72425V5.82425H7.62152H8.39923Z"
            fill={props.fill}
            stroke={props.fill}
            strokeWidth={0.2}
        />
        <rect x={11} y={9.03333} width={4} height={1} rx={0.5} fill="white" />
        <rect
            x={12.5}
            y={11.5333}
            width={4}
            height={1}
            rx={0.5}
            transform="rotate(-90 12.5 11.5333)"
            fill="white"
        />
        <path
            d="M4.5 9.53333C4.5 10.3618 3.82843 11.0333 3 11.0333C2.17157 11.0333 1.5 10.3618 1.5 9.53333C1.5 8.7049 2.17157 8.03333 3 8.03333C3.82843 8.03333 4.5 8.7049 4.5 9.53333Z"
            fill={props.fill}
            stroke="white"
        />
    </svg>
);

EntertainmentIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default EntertainmentIcon;
