import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FlightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.19285 10.0008C4.83287 9.20484 5.65742 8.22257 6.63435 7.15049L0.242721 2.88941C-0.007696 2.72246 -0.0753637 2.38412 0.0915809 2.13371L0.90639 0.911493C1.04933 0.697076 1.32293 0.6121 1.5622 0.707806L9.75138 3.98348C14.0025 0.00139259 15.4651 -0.263824 15.8645 0.135515C16.2644 0.53546 15.9978 2.00192 11.9984 6.268C10.4329 7.93781 7.8121 10.1907 5.99918 11.6994V15.2185C5.99918 15.3739 5.91136 15.516 5.77234 15.5855L5.03024 15.9566C4.82754 16.0579 4.58105 15.9758 4.4797 15.7731C4.47462 15.7629 4.46995 15.7525 4.46573 15.7419L3.26354 12.7365L0.258056 11.5343C0.0476378 11.4501 -0.054709 11.2113 0.0294584 11.0009C0.0336826 10.9903 0.038344 10.9799 0.0434305 10.9698L0.414482 10.2277C0.483992 10.0886 0.626079 10.0008 0.781507 10.0008H4.19285ZM12.5068 7.47438L15.2922 14.4378C15.3879 14.6771 15.3029 14.9507 15.0885 15.0936L13.8663 15.9084C13.6159 16.0754 13.2775 16.0077 13.1106 15.7573L9.43727 10.2473C10.2916 9.5906 11.1596 8.83982 11.9984 8.0011C12.175 7.82441 12.3444 7.64876 12.5068 7.47438Z"
            fill={props.fill}
        />
    </svg>
);

FlightIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default FlightIcon;
