import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FoodAndBeverageIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9.14286 2.28568C9.14286 2.91686 8.63118 3.42854 8 3.42854C7.36882 3.42854 6.85714 2.91686 6.85714 2.28568C6.85714 1.6545 7.36882 1.14282 8 1.14282C8.63118 1.14282 9.14286 1.6545 9.14286 2.28568Z"
            fill={props.fill}
        />
        <path
            d="M1.71429 10.8571C0.649946 9.71425 0 8.90097 0 7.42854C0 5.85058 1.27919 4.57139 2.85714 4.57139C3.3556 4.57139 3.82425 4.69904 4.23218 4.92343C3.94378 5.16657 3.67177 5.43206 3.41836 5.71425H2.85714C1.91037 5.71425 1.14286 6.48176 1.14286 7.42854C1.14286 8.34899 1.8683 9.10002 2.77863 9.14106C3.4052 7.02194 5.14566 4.57139 8 4.57139C12.5714 4.57139 14.2857 10.8571 13.1429 12C12 13.1428 10 13.7143 8 13.7143C6 13.7143 4 13.1428 2.85714 12C2.7661 11.9089 2.72352 11.8737 2.67753 11.8357C2.57357 11.7498 2.45221 11.6495 1.71429 10.8571Z"
            fill={props.fill}
        />
        <path
            d="M14.7093 10.4509C15.3128 9.35756 15.7431 7.39772 16 4.57139H14.8571L13.0914 6.33712C14.0508 7.6237 14.6465 9.13915 14.7093 10.4509Z"
            fill={props.fill}
        />
    </svg>
);

FoodAndBeverageIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default FoodAndBeverageIcon;
