import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FurnitureIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M8.00002 1.71423C12.4797 1.71423 13.0574 4.59337 12.6539 7.21678C11.7407 7.53664 11.0857 8.4061 11.0857 9.42852V9.84775C10.16 9.58366 9.08004 9.37138 8.00002 9.37138C6.92001 9.37138 5.84 9.58366 4.91431 9.84775V9.42852C4.91431 8.4061 4.25939 7.53664 3.34617 7.21678C2.94268 4.59337 3.52031 1.71423 8.00002 1.71423Z"
            fill={props.fill}
        />
        <path
            d="M8.01689 10.2857C6.6814 10.2857 5.34244 10.5216 4.00003 10.9935V9.42852C4.00003 8.63954 3.36043 7.99995 2.57145 7.99995C1.78248 7.99995 1.14288 8.63954 1.14288 9.42852C1.14288 10.1635 1.69794 10.7689 2.41174 10.8483L2.85717 14.8571H4.00003L4.00002 13.274C5.33283 13.4151 6.66564 13.4857 7.99846 13.4857C9.33168 13.4857 10.6655 13.4151 12 13.2739V14.8571H13.1429L13.5883 10.8483C14.3021 10.7689 14.8572 10.1635 14.8572 9.42852C14.8572 8.63954 14.2176 7.99995 13.4286 7.99995C12.6396 7.99995 12 8.63954 12 9.42852C12 9.44771 12.0004 9.46681 12.0012 9.48581L12 10.9778C10.6652 10.5164 9.33753 10.2857 8.01689 10.2857Z"
            fill={props.fill}
        />
    </svg>
);

FurnitureIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default FurnitureIcon;
