import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GeolocationIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0.999939 7.12434L6.24947 9.74926L8.87603 14.9991L14.9991 0.999939L0.999939 7.12434Z"
            fill={props.fill}
        />
    </svg>
);

GeolocationIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default GeolocationIcon;
