import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GiftIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M13.5999 5H12.5445C13.3387 4.19218 13.5788 3.01759 13.054 2.10047C12.408 0.971567 10.5985 0.660256 9.31968 1.40514C8.80482 1.70504 8.33021 2.17647 7.98906 2.70637C7.6479 2.17647 7.1733 1.70504 6.65844 1.40514C5.37965 0.660256 3.59186 0.971567 2.94584 2.10047C2.42101 3.01759 2.6611 4.19218 3.45531 5H2.39992C2.02655 5 1.83987 5 1.69726 5.07266C1.57182 5.13658 1.46983 5.23856 1.40591 5.36401C1.33325 5.50661 1.33325 5.6933 1.33325 6.06667L1.33332 6.9333C1.33332 7.30667 1.33332 7.49335 1.40598 7.63596C1.46989 7.7614 1.57188 7.86339 1.69732 7.9273C1.83993 7.99997 2.02641 7.99997 2.39936 7.99997H13.6006C13.9736 7.99997 14.16 7.99997 14.3026 7.9273C14.4281 7.86339 14.5301 7.7614 14.594 7.63596C14.6666 7.49335 14.6666 7.30667 14.6666 6.9333L14.6666 6.06667C14.6666 5.6933 14.6666 5.50661 14.5939 5.36401C14.53 5.23856 14.428 5.13658 14.3026 5.07266C14.16 5 13.9733 5 13.5999 5ZM9.02744 4.22045C9.02923 4.01103 9.45922 3.20299 10.11 2.82391C10.6879 2.4873 11.5108 2.63673 11.6759 2.92514C11.8453 3.22117 11.6647 3.75605 11.1179 4.0745C10.7737 4.27505 10.1862 4.39678 9.6489 4.36097C9.42693 4.34617 9.23532 4.28902 9.02744 4.22045ZM4.32396 2.92514C4.49001 2.63496 5.29182 2.48822 5.86812 2.82391C6.52046 3.20389 6.95094 4.01489 6.95068 4.22194C6.74563 4.28825 6.55828 4.34633 6.33939 4.36101C5.80872 4.39662 5.22687 4.27545 4.88189 4.0745C4.33517 3.75605 4.15455 3.22117 4.32396 2.92514Z"
            fill={props.fill}
        />
        <path
            d="M1.99998 8.99993H6.5V11.6739C6.5 11.8355 6.5 11.9163 6.53195 11.9537C6.55967 11.9861 6.60125 12.0033 6.64379 12C6.69283 11.9961 6.74995 11.939 6.86418 11.8248L7.84913 11.0065C7.90194 10.9537 7.92834 10.9273 7.95878 10.9174C7.98556 10.9087 8.01441 10.9087 8.04118 10.9174C8.07163 10.9273 8.09803 10.9537 8.15083 11.0065L9.13582 11.8248C9.25005 11.939 9.30717 11.9961 9.35621 12C9.39876 12.0033 9.44034 11.9861 9.46805 11.9537C9.5 11.9163 9.5 11.8355 9.5 11.6739V8.99993H14V13.6666C14 14.403 13.403 14.9999 12.6666 14.9999H3.33332C2.59694 14.9999 1.99998 14.403 1.99998 13.6666V8.99993Z"
            fill={props.fill}
        />
    </svg>
);

GiftIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default GiftIcon;
