import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HandLuggageNoSizeIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#ed47b9bc__clip0_18006_4215)">
            <path
                d="M8.43287e-06 7.34096C1.22514e-05 5.68411 1.34316 4.34097 3.00001 4.34097H13.0983C14.7551 4.34097 16.0983 5.68412 16.0983 7.34098L16.0983 10.9999C16.0983 12.6568 14.7551 13.9999 13.0983 13.9999H3C1.34314 13.9999 -3.81857e-06 12.6568 0 10.9999L8.43287e-06 7.34096Z"
                fill={props.fill}
            />
            <path
                d="M5.21565 3.42324L5.2085 3.52993H5.31543H5.91775H6.0093L6.01736 3.43873C6.10304 2.46921 6.94711 1.69267 7.96563 1.69267C8.98385 1.69267 9.82899 2.46917 9.9291 3.44018L9.93836 3.52993H10.0286H10.6309H10.739L10.7306 3.42213C10.6211 2.02111 9.41757 0.9 7.96563 0.9C6.51394 0.9 5.30961 2.0211 5.21565 3.42324Z"
                fill={props.fill}
                stroke={props.fill}
                strokeWidth={0.2}
            />
        </g>
        <defs>
            <clipPath id="ed47b9bc__clip0_18006_4215">
                <rect width={16} height={16} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

HandLuggageNoSizeIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default HandLuggageNoSizeIcon;
