import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LikeOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 17"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.382 5.47505H13.21C14.972 5.47505 15.997 6.41205 15.997 8.12805C15.997 8.66505 15.918 9.01505 15.737 9.47105L15.683 9.60505C15.6357 9.71825 15.5973 9.83493 15.568 9.95405C15.556 10.0041 15.557 10.0911 15.578 10.3641C15.634 11.1201 15.593 11.5741 15.296 12.1701C15.124 12.5131 14.915 12.798 14.647 13.0841C14.587 13.1481 14.454 13.2811 14.345 13.3901L14.181 13.5551C14.1369 13.597 14.0991 13.6452 14.069 13.6981C13.912 14.1211 13.81 14.3431 13.574 14.6631C13.001 15.4421 12.101 15.9031 10.869 15.9031H7.686C6.846 15.9031 6.166 15.7571 5.632 15.4871C5.357 15.8031 4.952 16.0031 4.5 16.0031H1.5C1.10218 16.0031 0.720644 15.845 0.43934 15.5637C0.158035 15.2824 0 14.9009 0 14.5031L0 9.00305C0 8.60523 0.158035 8.22369 0.43934 7.94239C0.720644 7.66109 1.10218 7.50305 1.5 7.50305H4.5C4.61 7.50305 4.718 7.51505 4.822 7.53705C5.492 6.88705 6.254 5.37105 6.505 4.06705C6.561 3.77605 6.607 3.48505 6.651 3.15705C6.676 2.97205 6.747 2.39705 6.752 2.35505V2.35205C6.953 0.793051 7.29 0.102051 8.5 0.102051C10.001 0.102051 11.52 1.65105 11.52 3.29205C11.52 3.91005 11.474 4.63605 11.382 5.47505ZM2 14.0031V9.50305H4V14.0031H2ZM8.435 3.39705C8.463 3.19305 8.539 2.57205 8.538 2.58105C8.578 2.26305 8.614 2.05505 8.648 1.92205C9.13 2.04205 9.721 2.70005 9.721 3.29205C9.721 4.05505 9.638 5.04405 9.471 6.25205C9.45342 6.37946 9.46336 6.50916 9.50014 6.63241C9.53691 6.75566 9.59968 6.86959 9.68421 6.96653C9.76874 7.06347 9.87306 7.14117 9.99015 7.19439C10.1072 7.24761 10.2344 7.27511 10.363 7.27505H13.21C14.012 7.27505 14.197 7.44505 14.197 8.12805C14.197 8.41405 14.167 8.54705 14.064 8.80705L14.01 8.94205C13.9305 9.13515 13.866 9.33406 13.817 9.53705C13.746 9.83705 13.747 10.029 13.782 10.4991C13.817 10.956 13.8 11.1351 13.686 11.3651C13.5934 11.5444 13.4744 11.7089 13.333 11.8531C13.302 11.8871 13.216 11.9731 13.126 12.0631C13.02 12.168 12.908 12.2811 12.863 12.3291C12.64 12.5691 12.484 12.7941 12.381 13.0721C12.281 13.3441 12.231 13.4521 12.125 13.5951C11.889 13.9161 11.525 14.1031 10.869 14.1031H7.686C6.256 14.1031 5.903 13.6871 5.903 12.5761V8.98105C6.977 8.04105 7.943 6.12205 8.273 4.40805C8.335 4.08005 8.387 3.75605 8.435 3.39705Z"
            fill={props.fill}
        />
    </svg>
);

LikeOutlineIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default LikeOutlineIcon;
