import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ListIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M3 2C2.73478 2 2.48043 1.89464 2.29289 1.70711C2.10536 1.51957 2 1.26522 2 1C2 0.734784 2.10536 0.48043 2.29289 0.292893C2.48043 0.105357 2.73478 0 3 0H13C13.2652 0 13.5196 0.105357 13.7071 0.292893C13.8946 0.48043 14 0.734784 14 1C14 1.26522 13.8946 1.51957 13.7071 1.70711C13.5196 1.89464 13.2652 2 13 2H3ZM12.5 3H3.5C3.10218 3 2.72064 3.15804 2.43934 3.43934C2.15804 3.72064 2 4.10218 2 4.5V11.5C2 11.8978 2.15804 12.2794 2.43934 12.5607C2.72064 12.842 3.10218 13 3.5 13H12.5C12.8978 13 13.2794 12.842 13.5607 12.5607C13.842 12.2794 14 11.8978 14 11.5V4.5C14 4.10218 13.842 3.72064 13.5607 3.43934C13.2794 3.15804 12.8978 3 12.5 3ZM4 11V5H12V11H4ZM2 15C2 15.2652 2.10536 15.5196 2.29289 15.7071C2.48043 15.8946 2.73478 16 3 16H13C13.2652 16 13.5196 15.8946 13.7071 15.7071C13.8946 15.5196 14 15.2652 14 15C14 14.7348 13.8946 14.4804 13.7071 14.2929C13.5196 14.1054 13.2652 14 13 14H3C2.73478 14 2.48043 14.1054 2.29289 14.2929C2.10536 14.4804 2 14.7348 2 15Z"
            fill={props.fill}
        />
    </svg>
);

ListIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ListIcon;
