import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LocationOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.2944 11.5681L10.2792 11.5755L10.2642 11.5832C9.41374 12.018 8.62735 12.5212 7.99927 13.1184C7.37215 12.5215 6.58666 12.0183 5.73555 11.5832L5.72091 11.5757L5.70613 11.5685C3.99025 10.7326 2.83379 9.00591 2.83379 7.03311C2.83379 4.26484 5.12135 1.97515 7.9999 1.97515C10.8782 1.97515 13.166 4.26542 13.166 7.03397C13.166 9.00714 12.0101 10.7333 10.2944 11.5681ZM9.00401 14.5177L9.03523 14.4849C9.49258 14.0102 10.1568 13.5474 11.0382 13.0968C13.3066 11.9931 14.866 9.69287 14.866 7.03397C14.866 3.30139 11.7917 0.275146 7.9999 0.275146C4.20809 0.275146 1.13379 3.30053 1.13379 7.03311C1.13379 9.69201 2.69412 11.9922 4.96165 13.0968C5.84271 13.5473 6.50594 14.0099 6.96263 14.4844L6.99405 14.5174C7.18441 14.7197 7.33739 14.9242 7.45384 15.1308L7.45559 15.1339C7.51864 15.2461 7.57092 15.359 7.61256 15.4725C7.66775 15.624 7.83865 15.7248 7.9999 15.7248C8.16114 15.7248 8.3298 15.624 8.38499 15.4725C8.42664 15.3589 8.47897 15.2461 8.54211 15.1338L8.54386 15.1307C8.66039 14.9242 8.81351 14.7199 9.00401 14.5177ZM8.00098 8.61011C7.17598 8.61011 6.50098 7.93511 6.50098 7.11011C6.50098 6.28511 7.17598 5.61011 8.00098 5.61011C8.82598 5.61011 9.50098 6.28511 9.50098 7.11011C9.50098 7.93511 8.82598 8.61011 8.00098 8.61011Z"
            fill={props.fill}
        />
    </svg>
);

LocationOutlineIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default LocationOutlineIcon;
