import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MapIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11 3.2791V11.7433L13 12.5233V3.94614L11 3.2791ZM9 3.41662V11.7446L7 12.5606V4.24794L9 3.41662ZM5 4.2545V12.7014L3 12.054V3.47006L5 4.2545ZM9.14329 1.19006L6 2.50005L2.36334 1.07006C1.70767 0.814348 1 1.29629 1 2.00006V12.777C1 13.2085 1.27682 13.5914 1.68662 13.7266L5.29595 14.9001C5.75021 15.05 6.24316 15.0325 6.68537 14.8501L10 13.5001L13.6367 14.9301C14.2923 15.1858 15 14.7038 15 14.0001V3.2231C15 2.79156 14.7232 2.4087 14.3134 2.27347L10.8801 1.13006C10.3122 0.942677 9.69605 0.962045 9.14329 1.19006Z"
            fill={props.fill}
        />
    </svg>
);

MapIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default MapIcon;
