import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MiniBarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M3.65713 0.816327C3.65713 0.588335 3.65713 0.474339 3.6892 0.382698C3.74664 0.218557 3.87569 0.0895021 4.03983 0.0320667C4.13147 0 4.24547 0 4.47346 0H5.81224C6.04023 0 6.15422 0 6.24587 0.0320667C6.41001 0.0895021 6.53906 0.218557 6.5965 0.382698C6.62856 0.474339 6.62856 0.588335 6.62856 0.816327C6.62856 0.907523 6.62856 0.953122 6.61574 0.989778C6.59276 1.05543 6.54114 1.10706 6.47548 1.13003C6.43883 1.14286 6.39323 1.14286 6.30203 1.14286H3.98366C3.89247 1.14286 3.84687 1.14286 3.81021 1.13003C3.74456 1.10706 3.69293 1.05543 3.66996 0.989778C3.65713 0.953122 3.65713 0.907523 3.65713 0.816327Z"
            fill={props.fill}
        />
        <path
            d="M7.21805 5.74503C6.98255 6.11275 6.85713 6.54052 6.85713 6.97777V15.7943C6.28571 15.9314 5.71428 16 5.14285 16C4.31861 16 3.49437 15.8573 2.67013 15.572C2.44002 15.4923 2.28571 15.2755 2.28571 15.032V7.78853C2.28571 7.56751 2.30285 7.36596 2.33984 7.17537C2.37683 6.98478 2.43366 6.80515 2.51303 6.62796C2.59239 6.45078 2.69429 6.27604 2.82142 6.09524L3.05365 5.76495C3.19207 5.56809 3.23294 5.50497 3.2735 5.43059C3.31406 5.35622 3.343 5.28665 3.36718 5.20545C3.39136 5.12425 3.40733 5.05077 3.44941 4.81383L3.99999 1.71429H6.28571L6.83628 4.81383C6.87837 5.05077 6.89434 5.12425 6.91852 5.20545C6.94269 5.28665 6.97164 5.35622 7.0122 5.43059C7.05136 5.50241 7.09081 5.56372 7.21805 5.74503Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.04493 7.21331C7.99999 7.45499 7.99999 7.70566 7.99999 8.207V14.8096C7.99999 15.0279 7.99999 15.137 8.04151 15.2399C8.0756 15.3244 8.14285 15.4149 8.21394 15.4719C8.30049 15.5413 8.39552 15.5699 8.58557 15.6271C9.13375 15.7921 9.99544 16 10.8571 16C11.7188 16 12.5805 15.7921 13.1287 15.6271C13.3188 15.5699 13.4138 15.5413 13.5003 15.4719C13.5714 15.4149 13.6387 15.3244 13.6728 15.2399C13.7143 15.137 13.7143 15.0279 13.7143 14.8096V8.207C13.7143 7.70566 13.7143 7.45499 13.6693 7.21331C13.6295 6.99882 13.5634 6.79004 13.4727 6.59164C13.3704 6.36809 13.2262 6.16303 12.9379 5.75292L12.9153 5.72085C12.8136 5.57625 12.7628 5.50393 12.7222 5.42636C12.6862 5.35747 12.6563 5.28555 12.6328 5.21144C12.6064 5.128 12.5909 5.04097 12.56 4.86691L12 1.71429H9.71428L9.15427 4.86691C9.12335 5.04097 9.10789 5.128 9.08145 5.21144C9.05796 5.28555 9.02804 5.35747 8.99202 5.42636C8.95147 5.50393 8.90063 5.57623 8.79896 5.72084L8.7764 5.75292C8.48804 6.16303 8.34386 6.36809 8.24161 6.59164C8.15087 6.79004 8.08481 6.99882 8.04493 7.21331ZM10.2857 9.14286H12C12.3156 9.14286 12.5714 9.39869 12.5714 9.71429V12C12.5714 12.3156 12.3156 12.5714 12 12.5714H10.2857V14.0571C10.2857 14.3727 10.0299 14.6286 9.71428 14.6286C9.39869 14.6286 9.14285 14.3727 9.14285 14.0571V7.8873C9.14285 7.21559 9.34168 6.5589 9.71428 6L10.1272 5.38059C10.2306 5.22557 10.2857 5.04344 10.2857 4.85714C10.2857 4.69935 10.4136 4.57143 10.5714 4.57143C10.7292 4.57143 10.8571 4.69935 10.8571 4.85714V5.14286C10.8571 5.51865 10.7696 5.88927 10.6016 6.22539L10.5714 6.28571C10.3835 6.6615 10.2857 7.07588 10.2857 7.49602V9.14286Z"
            fill={props.fill}
        />
        <path
            d="M9.40349 0.382698C9.37142 0.474339 9.37142 0.588335 9.37142 0.816327C9.37142 0.907523 9.37142 0.953122 9.38425 0.989778C9.40722 1.05543 9.45884 1.10706 9.5245 1.13003C9.56116 1.14286 9.60675 1.14286 9.69795 1.14286H12.0163C12.1075 1.14286 12.1531 1.14286 12.1898 1.13003C12.2554 1.10706 12.307 1.05543 12.33 0.989778C12.3428 0.953122 12.3428 0.907523 12.3428 0.816327C12.3428 0.588335 12.3428 0.474339 12.3108 0.382698C12.2533 0.218557 12.1243 0.0895021 11.9602 0.0320667C11.8685 0 11.7545 0 11.5265 0H10.1877C9.95975 0 9.84576 0 9.75412 0.0320667C9.58998 0.0895021 9.46092 0.218557 9.40349 0.382698Z"
            fill={props.fill}
        />
    </svg>
);

MiniBarIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default MiniBarIcon;
