import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NewspaperIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M3.4286 14.8571H14.8572C13.5948 14.8571 12.5715 13.8338 12.5715 12.5714V2.85713C12.5715 2.54154 12.3156 2.28571 12 2.28571H1.71431C1.39872 2.28571 1.14288 2.54154 1.14288 2.85713V12.5714C1.14288 13.8338 2.16623 14.8571 3.4286 14.8571ZM3.45351 4.69622C3.4286 4.74512 3.4286 4.80912 3.4286 4.93713V6.49142C3.4286 6.61943 3.4286 6.68344 3.45351 6.73233C3.47542 6.77534 3.51039 6.81031 3.5534 6.83222C3.60229 6.85713 3.6663 6.85713 3.79431 6.85713H9.92003C10.048 6.85713 10.112 6.85713 10.1609 6.83222C10.2039 6.81031 10.2389 6.77534 10.2608 6.73233C10.2857 6.68344 10.2857 6.61943 10.2857 6.49142V4.93713C10.2857 4.80912 10.2857 4.74512 10.2608 4.69622C10.2389 4.65321 10.2039 4.61825 10.1609 4.59633C10.112 4.57142 10.048 4.57142 9.92003 4.57142H3.79431C3.6663 4.57142 3.60229 4.57142 3.5534 4.59633C3.51039 4.61825 3.47542 4.65321 3.45351 4.69622ZM8.00003 9.50856C8.00003 9.38055 8.00003 9.31654 8.02494 9.26765C8.04685 9.22464 8.08182 9.18967 8.12483 9.16776C8.17372 9.14285 8.23773 9.14285 8.36574 9.14285H9.92003C10.048 9.14285 10.112 9.14285 10.1609 9.16776C10.2039 9.18967 10.2389 9.22464 10.2608 9.26765C10.2857 9.31654 10.2857 9.38055 10.2857 9.50856V9.91999C10.2857 10.048 10.2857 10.112 10.2608 10.1609C10.2389 10.2039 10.2039 10.2389 10.1609 10.2608C10.112 10.2857 10.048 10.2857 9.92003 10.2857H8.36574C8.23773 10.2857 8.17372 10.2857 8.12483 10.2608C8.08182 10.2389 8.04685 10.2039 8.02494 10.1609C8.00003 10.112 8.00003 10.048 8.00003 9.91999V9.50856ZM8.02494 11.5534C8.00003 11.6023 8.00003 11.6663 8.00003 11.7943V12.2057C8.00003 12.3337 8.00003 12.3977 8.02494 12.4466C8.04685 12.4896 8.08182 12.5246 8.12483 12.5465C8.17372 12.5714 8.23773 12.5714 8.36574 12.5714H9.92003C10.048 12.5714 10.112 12.5714 10.1609 12.5465C10.2039 12.5246 10.2389 12.4896 10.2608 12.4466C10.2857 12.3977 10.2857 12.3337 10.2857 12.2057V11.7943C10.2857 11.6663 10.2857 11.6023 10.2608 11.5534C10.2389 11.5104 10.2039 11.4754 10.1609 11.4535C10.112 11.4286 10.048 11.4286 9.92003 11.4286H8.36574C8.23773 11.4286 8.17372 11.4286 8.12483 11.4535C8.08182 11.4754 8.04685 11.5104 8.02494 11.5534ZM3.45351 9.26765C3.4286 9.31654 3.4286 9.38055 3.4286 9.50856V12.2057C3.4286 12.3337 3.4286 12.3977 3.45351 12.4466C3.47542 12.4896 3.51039 12.5246 3.5534 12.5465C3.60229 12.5714 3.6663 12.5714 3.79431 12.5714H5.3486C5.47661 12.5714 5.54062 12.5714 5.58951 12.5465C5.63252 12.5246 5.66748 12.4896 5.6894 12.4466C5.71431 12.3977 5.71431 12.3337 5.71431 12.2057V9.50856C5.71431 9.38055 5.71431 9.31654 5.6894 9.26765C5.66748 9.22464 5.63252 9.18967 5.58951 9.16776C5.54062 9.14285 5.47661 9.14285 5.3486 9.14285H3.79431C3.6663 9.14285 3.60229 9.14285 3.5534 9.16776C3.51039 9.18967 3.47542 9.22464 3.45351 9.26765Z"
            fill={props.fill}
        />
        <path
            d="M13.7143 6.85713H15.0857C15.4058 6.85713 15.5658 6.85713 15.688 6.91942C15.7955 6.9742 15.883 7.06162 15.9377 7.16914C16 7.29137 16 7.45139 16 7.77142V12.5714C16 13.2026 15.4884 13.7143 14.8572 13.7143C14.226 13.7143 13.7143 13.2026 13.7143 12.5714V6.85713Z"
            fill={props.fill}
        />
    </svg>
);

NewspaperIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default NewspaperIcon;
