import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NoTicketReturnIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#984c2628__clip0_21667_4751)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M8 13C9.32608 13 10.5979 12.4732 11.5355 11.5355C12.4732 10.5979 13 9.32608 13 8C13 6.67392 12.4732 5.40215 11.5355 4.46447C10.5979 3.52679 9.32608 3 8 3C6.77387 3.001 5.59193 3.45795 4.684 4.282L7 6.402L-0.00200081 8.127L1.099 1L3.196 2.92C4.49104 1.68634 6.21141 0.998768 8 1C9.85652 1 11.637 1.7375 12.9497 3.05025C14.2625 4.36301 15 6.14349 15 8C15 9.85652 14.2625 11.637 12.9497 12.9497C11.637 14.2625 9.85652 15 8 15C6.70048 14.9994 5.42682 14.6368 4.32182 13.9529C3.21682 13.269 2.32419 12.2908 1.744 11.128L3.545 10.227C4.367 11.865 6.043 13 8 13Z"
                fill={props.fill}
            />
            <path
                d="M3.44653 15.1758C3.44462 14.9581 3.52912 14.7332 3.68181 14.5494L14.5794 1.81687C14.7375 1.6375 14.9492 1.51631 15.169 1.4794C15.3888 1.44249 15.5991 1.4928 15.7545 1.61951C15.9099 1.74622 15.9981 1.93918 16 2.15684C16.0019 2.37449 15.9174 2.59943 15.7647 2.7832L4.86713 15.5158C4.70903 15.6951 4.49728 15.8163 4.27749 15.8532C4.0577 15.8901 3.84745 15.8398 3.69203 15.7131C3.5366 15.5864 3.44844 15.3934 3.44653 15.1758Z"
                fill="white"
            />
            <path
                d="M1.29687 15.1099C1.29479 14.8748 1.38702 14.6317 1.5537 14.4329L13.4493 0.659295C13.6218 0.465256 13.853 0.333937 14.0929 0.29362C14.3328 0.253304 14.5623 0.307216 14.732 0.443746C14.9016 0.580275 14.9979 0.788498 15 1.02357C15.0021 1.25864 14.9098 1.50174 14.7431 1.70053L2.84757 15.4741C2.67499 15.6682 2.44385 15.7995 2.20393 15.8398C1.96401 15.8801 1.7345 15.8262 1.56485 15.6897C1.39519 15.5532 1.29896 15.3449 1.29687 15.1099Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="984c2628__clip0_21667_4751">
                <rect width={16} height={16} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

NoTicketReturnIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default NoTicketReturnIcon;
