import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const OrdersIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M5.5 3.5C5.5 2.11929 6.61929 1 8 1C9.38071 1 10.5 2.11929 10.5 3.5V5H5.5V3.5Z"
            stroke={props.fill}
            strokeWidth={2}
        />
        <path
            d="M2 7C2 5.89543 2.89543 5 4 5H12C13.1046 5 14 5.89543 14 7V12C14 13.1046 13.1046 14 12 14H4C2.89543 14 2 13.1046 2 12V7Z"
            stroke={props.fill}
            strokeWidth={2}
        />
        <rect x={4.5} y={3} width={2} height={5} rx={1} fill={props.fill} />
        <rect x={9.5} y={3} width={2} height={5} rx={1} fill={props.fill} />
    </svg>
);

OrdersIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default OrdersIcon;
