import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PictureIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M1 2.5C1 1.67157 1.67157 1 2.5 1H13.5C14.3284 1 15 1.67157 15 2.5V13.5C15 14.3284 14.3284 15 13.5 15H2.5C1.67157 15 1 14.3284 1 13.5V2.5ZM4.48746 9.19632C4.63094 8.95239 4.9481 8.87607 5.18686 9.028L7.09633 10.2431C7.32209 10.3868 7.62093 10.3272 7.77439 10.108L10.4302 6.31395C10.6658 5.97739 11.1843 6.05282 11.3142 6.44257L13.2806 12.3419C13.3886 12.6657 13.1476 13 12.8063 13H3.12421C2.7375 13 2.49717 12.5798 2.69324 12.2465L4.48746 9.19632ZM6 4.5C6 5.32843 5.32843 6 4.5 6C3.67157 6 3 5.32843 3 4.5C3 3.67157 3.67157 3 4.5 3C5.32843 3 6 3.67157 6 4.5Z"
            fill={props.fill}
        />
    </svg>
);

PictureIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default PictureIcon;
