import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PinFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M13.7939 6.38289C14.1844 6.77342 14.8177 6.77328 15.2082 6.38275C15.5986 5.99242 15.5989 5.3595 15.2089 4.96889L15.201 4.961L10.956 0.717L10.946 0.707C10.5555 0.316535 9.92247 0.316535 9.532 0.707C9.14153 1.09747 9.14153 1.73054 9.532 2.121L9.542 2.131L7.238 4.435C5.24 3.967 3.094 4.569 1.642 6.021L0.935 6.728L4.354 10.147L0 14.501V15.915H1.414L5.768 11.562L9.188 14.982L9.896 14.275C11.377 12.794 11.959 10.696 11.483 8.678L13.786 6.375L13.7939 6.38289Z"
            fill={props.fill}
        />
    </svg>
);

PinFilledIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default PinFilledIcon;
