import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const RefreshIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 17 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8 13C6.67392 13 5.40215 12.4732 4.46447 11.5355C3.52678 10.5979 3 9.32608 3 8C3 6.67392 3.52678 5.40215 4.46447 4.46447C5.40215 3.52679 6.67392 3 8 3C9.22613 3.001 10.4081 3.45795 11.316 4.282L9 6.402L16.002 8.127L14.901 1L12.804 2.92C11.509 1.68634 9.78859 0.998768 8 1C6.14348 1 4.36301 1.7375 3.05025 3.05025C1.7375 4.36301 1 6.14349 1 8C1 9.85652 1.7375 11.637 3.05025 12.9497C4.36301 14.2625 6.14348 15 8 15C9.29952 14.9994 10.5732 14.6368 11.6782 13.9529C12.7832 13.269 13.6758 12.2908 14.256 11.128L12.455 10.227C11.633 11.865 9.957 13 8 13Z"
            fill={props.fill}
        />
    </svg>
);

RefreshIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default RefreshIcon;
