import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SanitizersIcon = (props: IIconProps): ReactElement => (
    <svg
        width={props.width}
        height={props.height}
        viewBox="0 0 16 16"
        fill="none"
        focusable={false}
        xmlns="http://www.w3.org/2000/svg"
    >
        <path
            d="M7.33366 0.333333C7.33366 0.149238 7.4829 0 7.66699 0H8.33366C8.51775 0 8.66699 0.149238 8.66699 0.333333V0.54306C8.66699 0.618814 8.62209 0.687415 8.57009 0.742511C8.51908 0.796569 8.46699 0.880921 8.46699 1C8.46699 1.11908 8.51908 1.20343 8.57009 1.25749C8.62209 1.31258 8.66699 1.38119 8.66699 1.45694V1.66667C8.66699 1.85076 8.51775 2 8.33366 2H7.66699C7.4829 2 7.33366 1.85076 7.33366 1.66667V0.333333Z"
            fill={props.fill}
        />
        <path
            d="M8.00185 4.66667C11.0003 4.66667 10.664 3.73333 10.664 3.73333C10.5798 3.17205 10.1064 2.69442 9.40408 2.38905C9.33156 2.35752 9.24893 2.39795 9.22606 2.47365C9.19143 2.58826 9.08583 2.66667 8.96611 2.66667H7.0358C6.91632 2.66667 6.81105 2.58815 6.77699 2.47364C6.75451 2.39805 6.67214 2.35753 6.59982 2.38897C5.89737 2.69434 5.42396 3.172 5.33975 3.73333C5.33975 3.73333 5.00336 4.66667 8.00185 4.66667Z"
            fill={props.fill}
        />
        <path
            d="M8.00033 11.8333C8.82875 11.8333 9.50033 11.1618 9.50033 10.3333C9.50033 9.50491 8.82875 8.83333 8.00033 8.83333C7.1719 8.83333 6.50033 9.50491 6.50033 10.3333C6.50033 11.1618 7.1719 11.8333 8.00033 11.8333Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.83357 4.65611C4.81482 4.6341 4.78799 4.62051 4.75908 4.62051C4.70822 4.62051 4.66699 4.66174 4.66699 4.71259V14.5963C4.66699 14.8595 4.74757 15.12 4.96017 15.2752C5.36559 15.5712 6.25419 16 8.00033 16C9.74646 16 10.6351 15.5712 11.0405 15.2752C11.2531 15.12 11.3337 14.8595 11.3337 14.5963V4.71259C11.3337 4.66174 11.2924 4.62051 11.2416 4.62051C11.2127 4.62051 11.1858 4.6341 11.1671 4.65611C10.9064 4.96213 10.1164 5.43333 8.00033 5.43333C5.88428 5.43333 5.09426 4.96213 4.83357 4.65611ZM10.3337 10.3333C10.3337 11.622 9.28899 12.6667 8.00033 12.6667C6.71166 12.6667 5.66699 11.622 5.66699 10.3333C5.66699 9.04467 6.71166 8 8.00033 8C9.28899 8 10.3337 9.04467 10.3337 10.3333Z"
            fill={props.fill}
        />
        <path
            d="M11.8337 1C12.1098 1 12.3337 0.776142 12.3337 0.5C12.3337 0.223858 12.1098 0 11.8337 0C11.5575 0 11.3337 0.223858 11.3337 0.5C11.3337 0.776142 11.5575 1 11.8337 1Z"
            fill={props.fill}
        />
        <path
            d="M10.667 1C10.667 1.27614 10.4431 1.5 10.167 1.5C9.89085 1.5 9.66699 1.27614 9.66699 1C9.66699 0.723858 9.89085 0.5 10.167 0.5C10.4431 0.5 10.667 0.723858 10.667 1Z"
            fill={props.fill}
        />
        <path
            d="M11.5003 2.66667C11.7765 2.66667 12.0003 2.44281 12.0003 2.16667C12.0003 1.89052 11.7765 1.66667 11.5003 1.66667C11.2242 1.66667 11.0003 1.89052 11.0003 2.16667C11.0003 2.44281 11.2242 2.66667 11.5003 2.66667Z"
            fill={props.fill}
        />
    </svg>
);

SanitizersIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SanitizersIcon;
