import React from 'react';

import {IIconProps} from 'icons/types/icon';

const SelectArrow: React.FC<IIconProps> = props => {
    return (
        <svg viewBox="0 0 6 14" focusable={false} {...props}>
            <path d="M3 0L6 6H0L3 0Z" fill={props.fill} />
            <path d="M3 14L6 8H0L3 14Z" fill={props.fill} />
        </svg>
    );
};

SelectArrow.defaultProps = {
    width: 6,
    height: 14,
    fill: 'currentColor',
};

export default SelectArrow;
