import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ShareOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.9 6.40313C11.024 6.40313 10.2328 6.03976 9.66895 5.45552L6.29714 7.10839C6.36421 7.36202 6.39995 7.6284 6.39995 7.90313C6.39995 8.24166 6.34568 8.56753 6.24537 8.87249L9.66895 10.5508C10.2328 9.9665 11.024 9.60313 11.9 9.60313C13.6121 9.60313 15 10.9911 15 12.7031C15 14.4152 13.6121 15.8031 11.9 15.8031C10.1879 15.8031 8.79995 14.4152 8.79995 12.7031C8.79995 12.5876 8.80627 12.4735 8.81859 12.3613L5.00559 10.4921C4.51631 10.8151 3.93009 11.0031 3.29995 11.0031C1.58787 11.0031 0.199951 9.61521 0.199951 7.90313C0.199951 6.19104 1.58787 4.80313 3.29995 4.80313C4.00345 4.80313 4.65221 5.03746 5.17245 5.43234L8.81859 3.64501C8.80627 3.53274 8.79995 3.41867 8.79995 3.30313C8.79995 1.59104 10.1879 0.203125 11.9 0.203125C13.6121 0.203125 15 1.59104 15 3.30313C15 5.01521 13.6121 6.40313 11.9 6.40313ZM13.1 3.30313C13.1 3.96587 12.5627 4.50313 11.9 4.50313C11.2373 4.50313 10.7 3.96587 10.7 3.30313C10.7 2.64038 11.2373 2.10313 11.9 2.10313C12.5627 2.10313 13.1 2.64038 13.1 3.30313ZM11.9 13.9031C12.5627 13.9031 13.1 13.3659 13.1 12.7031C13.1 12.0404 12.5627 11.5031 11.9 11.5031C11.2373 11.5031 10.7 12.0404 10.7 12.7031C10.7 13.3659 11.2373 13.9031 11.9 13.9031ZM4.49995 7.90313C4.49995 8.56587 3.96269 9.10313 3.29995 9.10313C2.63721 9.10313 2.09995 8.56587 2.09995 7.90313C2.09995 7.24038 2.63721 6.70313 3.29995 6.70313C3.96269 6.70313 4.49995 7.24038 4.49995 7.90313Z"
            fill={props.fill}
        />
    </svg>
);

ShareOutlineIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ShareOutlineIcon;
