import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ShowerIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M3.87002 1.45319C2.53435 1.45319 1.45319 2.53316 1.45319 3.86705V14.5319C1.45319 15.3345 0.802576 15.9851 0 15.9851V3.86705C0 1.72879 1.73357 0 3.87002 0C5.33588 0 6.67593 0.828194 7.33148 2.1393L7.7385 2.89454C7.76955 2.95215 7.75818 3.02312 7.70827 3.06546C7.61199 3.14713 7.43777 3.28476 7.21771 3.41443C6.97852 3.55539 6.71865 3.61047 6.58398 3.63086C6.52765 3.63938 6.47395 3.60977 6.44692 3.55962L6.0317 2.78918C5.62231 1.9704 4.78545 1.45319 3.87002 1.45319Z"
            fill={props.fill}
        />
        <path
            d="M13.1461 8.86093C13.3207 9.19697 13.1893 9.61064 12.8526 9.78489C12.516 9.95914 12.1016 9.82798 11.9271 9.49194C11.7525 9.15591 11.9045 7.95954 11.9045 7.95954C11.9045 7.95954 12.9716 8.5249 13.1461 8.86093Z"
            fill={props.fill}
        />
        <path
            d="M15.9228 9.73976C16.0973 10.0758 15.9659 10.4895 15.6293 10.6637C15.2927 10.838 14.8783 10.7068 14.7038 10.3708C14.5292 10.0347 14.6812 8.83837 14.6812 8.83837C14.6812 8.83837 15.7482 9.40373 15.9228 9.73976Z"
            fill={props.fill}
        />
        <path
            d="M11.9722 12.5567C12.3088 12.3825 12.4402 11.9688 12.2657 11.6328C12.0911 11.2968 11.0241 10.7314 11.0241 10.7314C11.0241 10.7314 10.8721 11.9278 11.0466 12.2638C11.2212 12.5998 11.6356 12.731 11.9722 12.5567Z"
            fill={props.fill}
        />
        <path
            d="M9.48898 10.754C9.66352 11.09 9.53213 11.5037 9.1955 11.6779C8.85887 11.8522 8.44448 11.721 8.26993 11.385C8.09539 11.0489 8.24737 9.85257 8.24737 9.85257C8.24737 9.85257 9.31443 10.4179 9.48898 10.754Z"
            fill={props.fill}
        />
        <path
            d="M8.60854 13.5258C8.78308 13.8619 8.65169 14.2755 8.31506 14.4498C7.97843 14.624 7.56404 14.4929 7.3895 14.1568C7.21495 13.8208 7.36693 12.6244 7.36693 12.6244C7.36693 12.6244 8.43399 13.1898 8.60854 13.5258Z"
            fill={props.fill}
        />
        <path
            d="M8.33686 3.71396C8.42906 3.62023 8.56898 3.58555 8.68893 3.63937L11.6146 4.95204C11.8721 5.00944 12.0079 5.27072 11.8577 5.48759C11.5396 5.94702 10.8281 6.71568 9.31328 7.49255C7.79847 8.26943 6.75909 8.39871 6.20034 8.389C5.93659 8.38442 5.80362 8.1217 5.90724 7.87911L6.54838 4.73716C6.57466 4.60834 6.68447 4.51495 6.81439 4.49476C7.056 4.45722 7.33566 4.3769 7.63632 4.22271C7.93698 4.06851 8.16539 3.88827 8.33686 3.71396Z"
            fill={props.fill}
        />
    </svg>
);

ShowerIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ShowerIcon;
