import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SkiIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.4757 6.92302H8.79669e-05V6.23072L5.90782 5.89314L8.39963 3.22406C8.7939 2.80149 9.46735 2.76914 9.90354 3.15111C10.0342 3.26604 10.1309 3.40988 10.1884 3.55992L11.1382 6.06644L13.4264 6.15385C13.8001 6.1683 14.0906 6.47319 14.0764 6.8352C14.0622 7.17862 13.7745 7.44978 13.4264 7.46424L10.5848 7.57366C10.3205 7.5833 10.0833 7.45529 9.94829 7.25501L9.87938 7.15109L9.12778 6.0279L8.4757 6.92302ZM8.52525 7.65564L10.4932 9.5007L10.5983 9.59843C10.9251 9.90607 10.9691 10.3899 10.724 10.7443L8.36729 13.3824L11.7056 13.9287C12.5164 14.0613 13.3346 13.7379 13.8356 13.0867L13.9658 12.9174C14.16 12.6648 14.5223 12.6176 14.7748 12.8118C15.0274 13.0061 15.0746 13.3683 14.8803 13.6209L14.7501 13.7902C13.9902 14.778 12.7492 15.2686 11.5192 15.0673L0.483841 13.2616C0.1694 13.2101 -0.0437938 12.9135 0.00766027 12.599C0.0591143 12.2846 0.355731 12.0714 0.670172 12.1229L6.58209 13.0903C6.5843 13.086 6.58656 13.0818 6.58886 13.0777L8.57652 10.5681L5.43515 8.57228C5.16264 8.39919 4.97909 8.14426 4.89635 7.86301L8.52525 7.65564ZM11.1923 2.99998C10.3639 2.99998 9.69232 2.32841 9.69232 1.49999C9.69232 0.671568 10.3639 0 11.1923 0C12.0207 0 12.6923 0.671568 12.6923 1.49999C12.6923 2.32841 12.0207 2.99998 11.1923 2.99998Z"
            fill={props.fill}
        />
    </svg>
);

SkiIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SkiIcon;
