import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SortDescendingIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M1 2C0.447715 2 0 2.44772 0 3C0 3.55228 0.447715 4 1 4H15C15.5523 4 16 3.55228 16 3C16 2.44772 15.5523 2 15 2H1ZM0 8C0 7.44772 0.447715 7 1 7H11C11.5523 7 12 7.44772 12 8C12 8.55228 11.5523 9 11 9H1C0.447715 9 0 8.55228 0 8ZM0 13C0 12.4477 0.447715 12 1 12H7C7.55228 12 8 12.4477 8 13C8 13.5523 7.55228 14 7 14H1C0.447715 14 0 13.5523 0 13Z"
            fill={props.fill}
        />
    </svg>
);

SortDescendingIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SortDescendingIcon;
