import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SoundproofIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 17 17"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M11.7729 5.57225C11.4351 5.302 10.9283 5.33578 10.6412 5.69049C10.3541 6.04519 10.4216 6.55191 10.7763 6.83905C11.2324 7.21065 11.5195 7.78493 11.5195 8.40989C11.5195 9.08551 11.1986 9.67669 10.6919 10.0483C10.3709 10.2848 10.3203 10.7577 10.5736 11.0617L10.6412 11.1293C10.9114 11.4502 11.4182 11.5178 11.7391 11.2644C12.5836 10.6057 13.1241 9.55845 13.1241 8.40989C13.1241 7.26132 12.6005 6.24788 11.7729 5.57225Z"
            fill={props.fill}
        />
        <path
            d="M13.6139 3.30899C13.276 3.03874 12.7862 3.10631 12.4991 3.42723C12.2288 3.76504 12.2626 4.27176 12.6004 4.54201C13.7152 5.471 14.4415 6.85604 14.4415 8.40998C14.4415 9.96392 13.7152 11.3658 12.6004 12.2779C12.2626 12.5482 12.2288 13.0549 12.4991 13.3927C12.7693 13.7305 13.276 13.7981 13.6139 13.5279C15.1002 12.3286 16.063 10.4875 16.063 8.42687C16.0461 6.34932 15.1002 4.50823 13.6139 3.30899Z"
            fill={props.fill}
        />
        <path
            d="M7.0603 2.07588L2.95587 5.23443H0.945878C0.422267 5.23443 0 5.6567 0 6.18031V10.6395C0 11.1631 0.422267 11.5853 0.945878 11.5853H2.95587L7.07719 14.7439C7.80349 15.3013 8.83382 14.7946 8.83382 13.8656V2.9373C8.83382 2.04209 7.7866 1.51848 7.0603 2.07588Z"
            fill={props.fill}
        />
        <path
            d="M14.9548 16.998C14.6741 16.9808 14.4114 16.8541 14.2232 16.6451L1.28572 1.76219C1.10492 1.54675 1.01596 1.26892 1.03802 0.988536C1.06008 0.708152 1.19138 0.447649 1.40364 0.263132C1.6159 0.0786156 1.89214 -0.0151501 2.17287 0.00203024C2.45359 0.0192106 2.71634 0.145962 2.90451 0.354986L15.842 15.2379C16.0228 15.4533 16.1117 15.7311 16.0897 16.0115C16.0676 16.2919 15.9363 16.5524 15.7241 16.7369C15.5118 16.9214 15.2356 17.0152 14.9548 16.998Z"
            fill="white"
        />
        <path
            d="M12.4202 16.2327C12.1746 16.2177 11.9447 16.1068 11.78 15.9239L0.459716 2.90136C0.301516 2.71285 0.223684 2.46975 0.242983 2.22441C0.262282 1.97908 0.377169 1.75114 0.562898 1.58969C0.748627 1.42823 0.990339 1.34619 1.23597 1.36122C1.48161 1.37625 1.71151 1.48716 1.87616 1.67006L13.1965 14.6926C13.3547 14.8811 13.4325 15.1242 13.4132 15.3695C13.3939 15.6148 13.279 15.8428 13.0933 16.0042C12.9076 16.1657 12.6658 16.2477 12.4202 16.2327Z"
            fill={props.fill}
        />
    </svg>
);

SoundproofIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SoundproofIcon;
