import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M7.99961 12.8471L3.80257 15.3997C3.30959 15.6996 2.69944 15.2563 2.83226 14.6948L3.96302 9.91432L0.238341 6.71152C-0.19915 6.33532 0.0339088 5.61804 0.608967 5.57085L5.50486 5.16903L7.39992 0.636928C7.62251 0.104599 8.37671 0.104599 8.59929 0.636928L10.4944 5.16903L15.3903 5.57085C15.9653 5.61804 16.1984 6.33532 15.7609 6.71152L12.0362 9.91432L13.167 14.6948C13.2998 15.2563 12.6896 15.6996 12.1967 15.3997L7.99961 12.8471Z"
            fill={props.fill}
        />
    </svg>
);

StarIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default StarIcon;
