import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SwapHorizontalIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.8 0.603052C11.7257 0.547338 11.6374 0.513411 11.5449 0.505072C11.4524 0.496733 11.3594 0.514312 11.2764 0.555838C11.1933 0.597365 11.1235 0.661198 11.0747 0.740186C11.0259 0.819174 11 0.910196 11 1.00305V3.00305L1 3.00305C0.734784 3.00305 0.48043 3.10841 0.292893 3.29595C0.105357 3.48348 0 3.73784 0 4.00305C0 4.26827 0.105357 4.52262 0.292893 4.71016C0.48043 4.8977 0.734784 5.00305 1 5.00305L11 5.00305L11 7.00305C11 7.09591 11.0259 7.18693 11.0747 7.26592C11.1235 7.34491 11.1933 7.40874 11.2764 7.45027C11.3594 7.49179 11.4524 7.50937 11.5449 7.50103C11.6374 7.49269 11.7257 7.45877 11.8 7.40305L15.797 4.40305C15.8591 4.35648 15.9095 4.29609 15.9442 4.22666C15.9789 4.15723 15.997 4.08067 15.997 4.00305C15.997 3.92543 15.9789 3.84887 15.9442 3.77945C15.9095 3.71002 15.8591 3.64963 15.797 3.60305L11.8 0.603052ZM5 13.0031L5 15.0031C5 15.0959 4.97414 15.1869 4.92533 15.2659C4.87651 15.3449 4.80666 15.4087 4.72361 15.4503C4.64055 15.4918 4.54758 15.5094 4.4551 15.501C4.36262 15.4927 4.27428 15.4588 4.2 15.4031L0.203 12.4031C0.140902 12.3565 0.0905003 12.2961 0.0557864 12.2267C0.0210725 12.1572 0.003 12.0807 0.003 12.0031C0.003 11.9254 0.0210725 11.8489 0.0557864 11.7794C0.0905003 11.71 0.140902 11.6496 0.203 11.6031L4.2 8.60305C4.27428 8.54734 4.36262 8.51341 4.4551 8.50507C4.54758 8.49673 4.64055 8.51431 4.72361 8.55584C4.80666 8.59737 4.87651 8.6612 4.92533 8.74019C4.97414 8.81917 5 8.9102 5 9.00305V11.0031L15 11.0031C15.2652 11.0031 15.5196 11.1084 15.7071 11.2959C15.8946 11.4835 16 11.7378 16 12.0031C16 12.2683 15.8946 12.5226 15.7071 12.7102C15.5196 12.8977 15.2652 13.0031 15 13.0031L5 13.0031Z"
            fill={props.fill}
        />
    </svg>
);

SwapHorizontalIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SwapHorizontalIcon;
