import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SwapVerticalIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0.602929 4.2C0.547216 4.27428 0.513289 4.36262 0.50495 4.4551C0.496611 4.54758 0.514189 4.64055 0.555716 4.72361C0.597242 4.80666 0.661076 4.87651 0.740064 4.92533C0.819052 4.97414 0.910074 5 1.00293 5L3.00293 5L3.00293 15C3.00293 15.2652 3.10829 15.5196 3.29582 15.7071C3.48336 15.8946 3.73771 16 4.00293 16C4.26815 16 4.5225 15.8946 4.71004 15.7071C4.89757 15.5196 5.00293 15.2652 5.00293 15L5.00293 5L7.00293 5C7.09579 5 7.18681 4.97414 7.26579 4.92533C7.34478 4.87651 7.40862 4.80666 7.45014 4.72361C7.49167 4.64055 7.50925 4.54758 7.50091 4.4551C7.49257 4.36262 7.45864 4.27428 7.40293 4.2L4.40293 0.203C4.35636 0.140901 4.29596 0.0904997 4.22654 0.055786C4.15711 0.0210722 4.08055 0.0030001 4.00293 0.00300011C3.92531 0.00300011 3.84875 0.0210722 3.77932 0.055786C3.70989 0.0904997 3.6495 0.140901 3.60293 0.203L0.602929 4.2ZM13.0029 11L15.0029 11C15.0958 11 15.1868 11.0259 15.2658 11.0747C15.3448 11.1235 15.4086 11.1933 15.4501 11.2764C15.4917 11.3594 15.5092 11.4524 15.5009 11.5449C15.4926 11.6374 15.4586 11.7257 15.4029 11.8L12.4029 15.797C12.3564 15.8591 12.296 15.9095 12.2265 15.9442C12.1571 15.9789 12.0806 15.997 12.0029 15.997C11.9253 15.997 11.8488 15.9789 11.7793 15.9442C11.7099 15.9095 11.6495 15.8591 11.6029 15.797L8.60293 11.8C8.54722 11.7257 8.51329 11.6374 8.50495 11.5449C8.49661 11.4524 8.51419 11.3594 8.55572 11.2764C8.59724 11.1933 8.66108 11.1235 8.74006 11.0747C8.81905 11.0259 8.91007 11 9.00293 11L11.0029 11L11.0029 1C11.0029 0.734783 11.1083 0.480429 11.2958 0.292893C11.4834 0.105357 11.7377 -4.91088e-07 12.0029 -5.02681e-07C12.2681 -5.14274e-07 12.5225 0.105357 12.71 0.292893C12.8976 0.480429 13.0029 0.734783 13.0029 0.999999L13.0029 11Z"
            fill={props.fill}
        />
    </svg>
);

SwapVerticalIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SwapVerticalIcon;
