import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TicketReturnIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 17 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.00195 13C9.32804 13 10.5998 12.4732 11.5375 11.5355C12.4752 10.5979 13.002 9.32608 13.002 8C13.002 6.67392 12.4752 5.40215 11.5375 4.46447C10.5998 3.52679 9.32804 3 8.00195 3C6.77582 3.001 5.59388 3.45795 4.68595 4.282L7.00195 6.402L-4.76837e-05 8.127L1.10095 1L3.19795 2.92C4.493 1.68634 6.21337 0.998768 8.00195 1C9.85847 1 11.6389 1.7375 12.9517 3.05025C14.2645 4.36301 15.002 6.14349 15.002 8C15.002 9.85652 14.2645 11.637 12.9517 12.9497C11.6389 14.2625 9.85847 15 8.00195 15C6.70243 14.9994 5.42877 14.6368 4.32377 13.9529C3.21877 13.269 2.32614 12.2908 1.74595 11.128L3.54695 10.227C4.36895 11.865 6.04495 13 8.00195 13Z"
            fill={props.fill}
        />
    </svg>
);

TicketReturnIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default TicketReturnIcon;
