import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ToiletIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path d="M7.72728 0H6.9091V16H7.72728V0Z" fill={props.fill} />
        <path
            d="M9.9819 4.26033C10.0396 4.24323 10.1048 4.22498 10.1767 4.20638C10.5293 4.68934 11.1057 5 11.7501 5C12.4035 5 12.987 4.68056 13.3381 4.18594C13.4427 4.21146 13.5351 4.23688 13.6138 4.26017C13.8059 4.31709 13.934 4.48553 13.9538 4.68093L14.1817 6.93018C14.2059 7.16847 14.0652 7.39296 13.8348 7.47395C13.6639 7.53398 13.4503 7.60672 13.2227 7.67871L14.1097 11.2268C14.1268 11.2951 14.115 11.3672 14.0639 11.4166C13.9508 11.5259 13.6868 11.7197 13.1463 11.8538L12.943 14.8355C12.9239 15.1156 12.686 15.3333 12.3988 15.3333H12.0554L11.8778 11.9991C11.8359 11.9997 11.7933 12 11.75 12C11.7067 12 11.6641 11.9997 11.6222 11.9991L11.4446 15.3333H11.1012C10.8141 15.3333 10.5761 15.1156 10.557 14.8355L10.3537 11.8538C9.81325 11.7197 9.54916 11.5259 9.43607 11.4166C9.38499 11.3672 9.37321 11.2951 9.39027 11.2268L10.2841 7.65162C10.0886 7.58876 9.90665 7.52661 9.75727 7.47414C9.52644 7.39308 9.38572 7.16811 9.41029 6.92951L9.64192 4.6803C9.66201 4.48524 9.79001 4.31719 9.9819 4.26033Z"
            fill={props.fill}
        />
        <path
            d="M2.88645 0.666667C2.84544 0.666667 2.80446 0.668665 2.76365 0.672655C2.08547 0.738966 1.59068 1.33028 1.6585 1.99338L1.76195 3.00496C1.81973 3.56983 2.30586 4 2.88645 4C3.46704 4 3.95317 3.56983 4.01094 3.00496L4.1144 1.99338C4.11848 1.95349 4.12052 1.91341 4.12052 1.87332C4.12052 1.2069 3.56801 0.666667 2.88645 0.666667Z"
            fill={props.fill}
        />
        <path
            d="M1.37376 4.28507C1.13425 4.36857 0.929858 4.45619 0.779113 4.52638C0.603365 4.60822 0.500006 4.78387 0.500005 4.9742L0.5 8C0.5 8 0.501011 8.94404 1.27518 9.53494L1.37634 14.81C1.38191 15.1006 1.62443 15.3333 1.92169 15.3333H2.51206L2.88637 8.1578L3.26068 15.3333H3.85105C4.14831 15.3333 4.39083 15.1006 4.39641 14.81L4.49754 9.53618C5.2727 8.94537 5.2727 8 5.2727 8V4.97392C5.2727 4.78374 5.16951 4.6082 4.99394 4.52633C4.84326 4.45607 4.6389 4.36835 4.39937 4.28479C4.04332 4.72271 3.49522 5 2.88645 5C2.27781 5 1.72981 4.72283 1.37376 4.28507Z"
            fill={props.fill}
        />
        <path
            d="M10.5221 1.99338C10.4495 1.28305 11.02 0.666667 11.7501 0.666667C12.4114 0.666667 12.9418 1.17236 12.9818 1.79553L13.1542 1.62698C13.5652 1.22511 14.1524 1.23923 14.5502 1.66056L15.5 2.66667L15.1185 3.03968C14.7075 3.44156 14.1203 3.42744 13.7225 3.00611L12.9573 2.19557L12.8746 3.00496C12.8168 3.56983 12.3307 4 11.7501 4C11.1695 4 10.6834 3.56983 10.6256 3.00496L10.5221 1.99338Z"
            fill={props.fill}
        />
    </svg>
);

ToiletIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ToiletIcon;
