import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ToursIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.37609 7.75588L9.72408 11.4595C9.26148 11.4554 8.8004 11.4838 8.33519 11.5419L7.12257 8.21025C7.3203 8.135 7.52165 8.06008 7.72662 7.98548C7.94591 7.90566 8.1624 7.82913 8.37609 7.75588ZM5.76144 0.438835L5.89378 0.802428C5.66056 0.83246 5.43546 0.885336 5.21847 0.961057C5.01545 1.03191 4.81985 1.12265 4.63169 1.23327L4.50852 0.894861C4.38259 0.548876 4.56098 0.166315 4.90696 0.0403864C5.25295 -0.085542 5.63551 0.0928494 5.76144 0.438835ZM14.3458 5.06269C13.4063 3.67208 10.8388 0.737379 6.27953 1.51468C6.94489 2.15933 7.79353 3.49742 8.82546 5.52895C8.27849 5.70047 7.71341 5.89243 7.13007 6.10475C6.54413 6.31802 5.98542 6.5352 5.45388 6.75647C4.9354 4.52341 4.72594 2.94725 4.82553 2.02799C0.759604 4.3585 0.677808 8.29551 0.853083 9.97451C0.891653 10.344 1.32097 10.4998 1.62544 10.287C2.56441 9.63069 4.5292 8.41561 7.5324 7.32253C10.5334 6.23027 12.8149 5.89908 13.9547 5.79881C14.325 5.76624 14.5539 5.37067 14.3458 5.06269ZM3.33272 13.7766C3.11259 13.8507 2.89071 13.9254 2.66675 14C2.66675 14.3682 2.96522 14.6667 3.33341 14.6667H13.3334C14.0698 14.6667 14.6667 14.0697 14.6667 13.3333C10.2614 11.4453 7.0442 12.5278 3.33272 13.7766Z"
            fill={props.fill}
        />
    </svg>
);

ToursIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ToursIcon;
