import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.33121 0C5.86753 0 5.45874 0.304151 5.3255 0.748283L5.184 1.21992C4.23509 1.33444 3.28619 1.50685 2.33728 1.73714C1.55254 1.92758 1.00001 2.63025 1 3.43777V11.1985C1 12.5764 1.99529 13.7218 3.30616 13.9551L4.22609 13.2191C4.4034 13.0773 4.62371 13 4.85078 13H11.1492C11.3763 13 11.5966 13.0773 11.7739 13.2191L12.6938 13.9551C14.0047 13.7218 15 12.5764 15 11.1985V3.43776C15 2.63023 14.4475 1.92754 13.6627 1.73713C12.7138 1.50684 11.7649 1.33444 10.816 1.21992L10.6745 0.74829C10.5412 0.304154 10.1324 0 9.66875 0H6.33121ZM13.1351 7.16C13.0593 7.68165 12.574 8 12 8H4C3.42603 8 2.94071 7.68164 2.86485 7.16L2.41015 4.51605C2.33142 3.97466 2.71852 3.46835 3.30043 3.35155C4.86697 3.0372 6.43349 2.88002 8 2.88002C9.56653 2.88002 11.133 3.03719 12.6996 3.35155C13.2815 3.46833 13.6686 3.97464 13.5899 4.51603L13.1351 7.16ZM12 11C12.5523 11 13 10.5523 13 10C13 9.44771 12.5523 9 12 9C11.4477 9 11 9.44771 11 10C11 10.5523 11.4477 11 12 11ZM4 11C4.55228 11 5 10.5523 5 10C5 9.44771 4.55228 9 4 9C3.44772 9 3 9.44771 3 10C3 10.5523 3.44772 11 4 11ZM7 1C6.72386 1 6.5 1.22386 6.5 1.5C6.5 1.77614 6.72386 2 7 2H9C9.27614 2 9.5 1.77614 9.5 1.5C9.5 1.22386 9.27614 1 9 1H7Z"
            fill={props.fill}
        />
        <path
            d="M8.00028 16H12.2702C12.4407 16 12.5318 15.8003 12.4213 15.6704L11.2998 14.352C11.1098 14.1287 10.8313 14 10.5381 14H5.46247C5.16925 14 4.8908 14.1287 4.7008 14.352L3.57922 15.6704C3.46873 15.8003 3.55998 16 3.73051 16H8.00028Z"
            fill={props.fill}
        />
    </svg>
);

TrainIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default TrainIcon;
