import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TrainServicesBedclothesTavostIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 16 16" fill="none" focusable={false} {...props}>
        <path
            d="M16 13.727v-3.64c0-.327-.034-.446-.097-.566a.664.664 0 0 0-.275-.278c-.119-.064-.236-.098-.56-.098H3.208c-.622 0-.848-.061-1.078-.178a1.324 1.324 0 0 1-.547-.515c-.132-.224-.21-.448-.253-1.075l-.208-2.935c-.01-.157-.03-.213-.063-.269a.33.33 0 0 0-.137-.128C.865 4.015.808 4 .652 4H0v9.727h.7c.28 0 .381-.023.488-.07a.656.656 0 0 0 .265-.208c.07-.093.117-.187.185-.462l.18-.73h12.364l.18.73c.068.275.115.369.185.462.07.093.159.162.265.209.107.046.208.07.488.07h.7z"
            fill={props.fill}
        />
        <path
            d="M12.896 4.841a2.63 2.63 0 0 1 2.377 2.63.525.525 0 0 1-.523.529H6.79a.665.665 0 0 1-.61-.913 3.947 3.947 0 0 1 4.025-2.493l2.691.247zM5.455 5.795c0 .812-.652 1.47-1.455 1.47a1.462 1.462 0 0 1-1.455-1.47c0-.812.652-1.47 1.455-1.47s1.455.658 1.455 1.47z"
            fill={props.fill}
        />
    </svg>
);

TrainServicesBedclothesTavostIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default TrainServicesBedclothesTavostIcon;
