import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TransportStopIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.5 14C3.67157 14 3 13.3284 3 12.5C3 11.6716 3.67157 11 4.5 11C5.32843 11 6 11.6716 6 12.5C6 13.3284 5.32843 14 4.5 14Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.45858 12.9997C7.48582 12.8372 7.5 12.6702 7.5 12.5C7.5 10.8431 6.15685 9.5 4.5 9.5C3.45651 9.5 2.53746 10.0328 2 10.8411L2 8H3.53846C3.79336 8 4 7.79336 4 7.53846V5.46154C4 5.20664 3.79336 5 3.53846 5H2V3H11C13.0057 3 14.0057 3.66667 14 5H13.5C13.2239 5 13 5.22386 13 5.5V8C13 8.66667 13.3333 9.33333 14 10V12.6203C14 12.8298 13.8316 12.9997 13.6239 12.9997H7.45858ZM5.46154 5C5.20664 5 5 5.20664 5 5.46154V7.53846C5 7.79336 5.20664 8 5.46154 8H7.53846C7.79336 8 8 7.79336 8 7.53846V5.46154C8 5.20664 7.79336 5 7.53846 5H5.46154ZM9.46154 5C9.20664 5 9 5.19286 9 5.43077V11.5692C9 11.8071 9.20664 12 9.46154 12H11.5385C11.7934 12 12 11.8071 12 11.5692V5.43077C12 5.19286 11.7934 5 11.5385 5H9.46154Z"
            fill={props.fill}
        />
    </svg>
);

TransportStopIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default TransportStopIcon;
