import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const UserIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M8.00007 9.8C5.78007 9.8 4.20007 7.357 4.20007 4.51C4.20007 1.663 5.54807 0 8.00007 0C10.4541 0 11.8001 1.663 11.8001 4.51C11.8001 7.357 10.2221 9.8 8.00007 9.8ZM8.00507 16C4.71207 16 2.65707 15.732 1.83807 15.195C1.76414 15.1466 1.70437 15.0794 1.66485 15.0004C1.62532 14.9213 1.60746 14.8332 1.61307 14.745C1.75807 12.514 3.88807 11.4 8.00007 11.4C12.1121 11.4 14.2441 12.514 14.3961 14.743C14.4022 14.8317 14.3846 14.9204 14.3451 15C14.3055 15.0797 14.2455 15.1473 14.1711 15.196C13.3511 15.732 11.2961 16 8.00507 16Z"
            fill={props.fill}
        />
    </svg>
);

UserIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default UserIcon;
