import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnGardenIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M8.72531 2.85095C7.98503 1.90064 6.98134 0.950318 5.71425 0C2.66663 2.28571 1.14282 4.57143 1.14282 6.85714C1.14282 10.2857 3.42854 11.4286 5.71425 11.4286C5.8458 11.4286 5.97736 11.4248 6.10847 11.417L7.61595 7.89954C7.07649 7.5762 6.81408 6.91135 7.02121 6.28996C7.05417 6.19838 7.05417 6.19838 7.09562 6.11033L8.72531 2.85095Z"
            fill={props.fill}
        />
        <path
            d="M6.39996 12.5714L6.59603 15.5124C6.61362 15.7763 6.40434 16 6.1399 16H5.2886C5.02416 16 4.81488 15.7763 4.83247 15.5124L5.02854 12.5714H6.39996Z"
            fill={props.fill}
        />
        <path
            d="M15.7885 12.078L14.166 8.29219L11.7899 9.08421C11.5553 9.16241 11.3017 9.16241 11.0671 9.08421L8.69107 8.29219L7.06856 12.078C7.05895 12.1005 7.05116 12.1236 7.04524 12.1473C6.98401 12.3922 7.13293 12.6404 7.37786 12.7016L10.6179 13.5116L10.5341 15.5238C10.5338 15.5302 10.5337 15.5365 10.5337 15.5429C10.5337 15.7953 10.7384 16 10.9908 16H11.8662L11.8766 15.9999L11.8853 15.9996C12.1375 15.9891 12.3335 15.7761 12.323 15.5238L12.2391 13.5116L15.4792 12.7016C15.5029 12.6957 15.526 12.6879 15.5484 12.6783C15.7805 12.5789 15.888 12.3101 15.7885 12.078Z"
            fill={props.fill}
        />
        <path
            d="M14.7392 6.62142L11.633 0.408881C11.6109 0.364646 11.575 0.328778 11.5308 0.306661C11.4178 0.250206 11.2806 0.295972 11.2241 0.408881L8.11783 6.62142C8.11299 6.63109 8.10884 6.6411 8.10542 6.65136C8.06551 6.77112 8.13023 6.90056 8.24999 6.94048L11.4285 8L14.6071 6.94048C14.6173 6.93706 14.6274 6.93292 14.637 6.92808C14.7499 6.87163 14.7957 6.73433 14.7392 6.62142Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnGardenIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ViewOnGardenIcon;
