import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WarningFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8 16C12.4184 16 16 12.4184 16 8C16 3.5816 12.4184 0 8 0C3.5816 0 0 3.5816 0 8C0 12.4184 3.5816 16 8 16ZM6.8 11.9928C6.8 11.2992 7.3272 10.8 7.9928 10.8C8.6728 10.8 9.2 11.2992 9.2 11.9928C9.2 12.6864 8.6728 13.2 7.9928 13.2C7.3272 13.2 6.8 12.6864 6.8 11.9928ZM7.3376 3.2C7.28362 3.20006 7.23022 3.21104 7.1806 3.23228C7.13098 3.25352 7.08617 3.28458 7.04887 3.3236C7.01157 3.36262 6.98256 3.40878 6.96357 3.4593C6.94459 3.50983 6.93603 3.56368 6.9384 3.6176L7.1832 9.2176C7.18774 9.32061 7.23187 9.41788 7.3064 9.48913C7.38093 9.56038 7.48009 9.6001 7.5832 9.6H8.4176C8.52071 9.6001 8.61987 9.56038 8.6944 9.48913C8.76893 9.41788 8.81306 9.32061 8.8176 9.2176L9.0616 3.6176C9.06398 3.56361 9.05539 3.5097 9.03636 3.45912C9.01732 3.40854 8.98823 3.36234 8.95085 3.32331C8.91347 3.28428 8.86856 3.25323 8.81885 3.23204C8.76914 3.21085 8.71564 3.19995 8.6616 3.2H7.3376Z"
            fill={props.fill}
        />
    </svg>
);

WarningFilledIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default WarningFilledIcon;
