import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WashIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M14.33 11.73C13.8677 12.0019 13.4773 12.381 13.192 12.8351C12.9066 13.2893 12.7344 13.8054 12.69 14.34C12.69 14.7749 12.8628 15.1921 13.1703 15.4996C13.4779 15.8072 13.8951 15.98 14.33 15.98C14.765 15.98 15.1821 15.8072 15.4897 15.4996C15.7972 15.1921 15.97 14.7749 15.97 14.34C15.9256 13.8054 15.7533 13.2893 15.468 12.8351C15.1826 12.381 14.7924 12.0019 14.33 11.73Z"
            fill={props.fill}
        />
        <path
            d="M12.83 9.83996C12.83 10.24 13.5 10.56 14.33 10.56C15.16 10.56 15.83 10.24 15.83 9.83996C15.83 6.89996 13.9 5.14995 10.68 5.14995H9.97003V4.47997C9.96739 4.1104 9.81872 3.7569 9.55646 3.49651C9.29419 3.23612 8.93958 3.08995 8.57001 3.08996H7.34003V1.67998H9.41998C9.53321 1.9145 9.72274 2.10366 9.95746 2.21648C10.1922 2.3293 10.4582 2.35909 10.7121 2.30102C10.966 2.24294 11.1926 2.10043 11.3549 1.89678C11.5172 1.69313 11.6057 1.44041 11.6057 1.17998C11.6057 0.919557 11.5172 0.666835 11.3549 0.463186C11.1926 0.259536 10.966 0.117027 10.7121 0.0589499C10.4582 0.000873104 10.1922 0.0306649 9.95746 0.143484C9.72274 0.256302 9.53321 0.44546 9.41998 0.679983H4.24994C4.13653 0.442575 3.94582 0.250755 3.70905 0.136037C3.47227 0.0213195 3.20356 -0.00950574 2.94696 0.0486349C2.69036 0.106776 2.46114 0.250472 2.29694 0.456045C2.13273 0.661618 2.04327 0.916879 2.04327 1.17998C2.04327 1.44309 2.13273 1.69835 2.29694 1.90392C2.46114 2.10949 2.69036 2.25319 2.94696 2.31133C3.20356 2.36947 3.47227 2.33865 3.70905 2.22393C3.94582 2.10921 4.13653 1.91739 4.24994 1.67998H6.34003V3.09997H5.10004C4.9175 3.09997 4.7367 3.13595 4.56805 3.2058C4.39941 3.27565 4.2462 3.37806 4.11713 3.50713C3.98805 3.6362 3.88559 3.78942 3.81573 3.95806C3.74588 4.1267 3.71002 4.30744 3.71002 4.48998V5.15996H0.039978V8.15996H3.95001C4.16648 8.76348 4.56418 9.28534 5.08868 9.6541C5.61319 10.0229 6.23878 10.2205 6.87994 10.22C7.52076 10.2191 8.14576 10.0208 8.66998 9.65227C9.19421 9.28371 9.59228 8.76267 9.81 8.15996H10.72C12.86 8.15996 12.8699 9.21997 12.8699 9.85997L12.83 9.83996Z"
            fill={props.fill}
        />
    </svg>
);

WashIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default WashIcon;
