import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HomeIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.1483 1.45611C10.5008 0.847964 9.49921 0.847964 8.85174 1.45611L1.3595 8.49338C0.904198 8.92104 0.877834 9.64106 1.30061 10.1016C1.72339 10.5622 2.43521 10.5888 2.89051 10.1612L10 3.48341L17.1095 10.1612C17.5648 10.5888 18.2766 10.5622 18.6994 10.1016C19.1222 9.64106 19.0958 8.92104 18.6405 8.49338L11.1483 1.45611ZM5.5 12.1722C5.5 11.5437 4.99633 11.0342 4.375 11.0342C3.75368 11.0342 3.25 11.5437 3.25 12.1722V17.2931C3.25 18.2358 4.00552 19 4.9375 19H15.0625C15.9945 19 16.75 18.2358 16.75 17.2931V12.1722C16.75 11.5437 16.2463 11.0342 15.625 11.0342C15.0037 11.0342 14.5 11.5437 14.5 12.1722V16.7241H5.5V12.1722Z"
            fill={props.fill}
        />
    </svg>
);

HomeIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default HomeIcon;
