import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SortingDefaultIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5.237 4.79836C5.237 4.35926 5.58035 4 6 4C6.41965 4 6.76299 4.35926 6.76299 4.79836V11.9212C6.76299 12.5235 6.69783 13.1233 6.56919 13.7091L6.72614 13.8744L6.89034 13.5996C7.19615 13.0881 7.55636 12.6145 7.9641 12.1878L8.701 11.4168C8.99857 11.1054 9.47926 11.1054 9.77682 11.4168C10.0744 11.7281 10.0744 12.2391 9.77682 12.5504L6.80847 15.6501C6.36166 16.1166 5.63834 16.1166 5.19153 15.6501L2.22318 12.5504C1.92561 12.2391 1.92561 11.7281 2.22318 11.4168C2.52074 11.1054 3.00143 11.1054 3.299 11.4168L4.03592 12.1878C4.44366 12.6145 4.80385 13.0881 5.10966 13.5996L5.27386 13.8744L5.43081 13.7091C5.30216 13.1233 5.237 12.5235 5.237 11.9212V4.79836ZM14.763 15.2016C14.763 15.6407 14.4196 16 14 16C13.5804 16 13.237 15.6407 13.237 15.2016V8.07876C13.237 7.47648 13.3022 6.87667 13.4308 6.29091L13.2739 6.12557L13.1097 6.40037C12.8039 6.91188 12.4436 7.38554 12.0359 7.81219L11.299 8.58324C11.0014 8.8946 10.5207 8.8946 10.2232 8.58324C9.92561 8.27188 9.92561 7.76093 10.2232 7.44957L13.1915 4.34986C13.6383 3.88338 14.3617 3.88338 14.8085 4.34986L17.7768 7.44957C18.0744 7.76093 18.0744 8.27188 17.7768 8.58324C17.4793 8.8946 16.9986 8.8946 16.701 8.58324L15.9641 7.81219C15.5563 7.38554 15.1961 6.91188 14.8903 6.40037L14.7261 6.12557L14.5692 6.29091C14.6978 6.87667 14.763 7.47648 14.763 8.07876V15.2016Z"
            fill={props.fill}
        />
    </svg>
);

SortingDefaultIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default SortingDefaultIcon;
