import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SortingDownIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9.237 4.79836C9.237 4.35926 9.58035 4 10 4C10.4196 4 10.763 4.35926 10.763 4.79836V11.9212C10.763 12.5235 10.6978 13.1233 10.5692 13.7091L10.7261 13.8744L10.8903 13.5996C11.1961 13.0881 11.5564 12.6145 11.9641 12.1878L12.701 11.4168C12.9986 11.1054 13.4793 11.1054 13.7768 11.4168C14.0744 11.7281 14.0744 12.2391 13.7768 12.5504L10.8085 15.6501C10.3617 16.1166 9.63834 16.1166 9.19153 15.6501L6.22318 12.5504C5.92561 12.2391 5.92561 11.7281 6.22318 11.4168C6.52074 11.1054 7.00143 11.1054 7.299 11.4168L8.03592 12.1878C8.44366 12.6145 8.80385 13.0881 9.10966 13.5996L9.27386 13.8744L9.43081 13.7091C9.30216 13.1233 9.237 12.5235 9.237 11.9212V4.79836Z"
            fill={props.fill}
        />
    </svg>
);

SortingDownIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default SortingDownIcon;
