import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SupportChatIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.1491 3.10166C2.8929 3.8747 2 5.25186 2 8C2 12.3723 4.3839 13.8152 5.24254 14.0299C5.6877 14.1411 6 14.5411 6 15V17.0793L9.42654 14.6808C9.59462 14.5631 9.79483 14.5 10 14.5C12.7062 14.5 14.6836 14.1206 15.9782 13.1885C17.195 12.3123 18 10.7992 18 8C18 5.25186 17.1071 3.8747 15.8509 3.10166C14.4832 2.26001 12.4846 2 10 2C7.51544 2 5.51677 2.26001 4.1491 3.10166ZM3.1009 1.39834C4.98323 0.239988 7.48456 0 10 0C12.5154 0 15.0168 0.239988 16.8991 1.39834C18.8929 2.6253 20 4.74814 20 8C20 11.2008 19.055 13.4377 17.1468 14.8115C15.386 16.0793 12.9847 16.4704 10.3176 16.4984L5.57346 19.8192C5.26799 20.0331 4.86892 20.0592 4.53819 19.887C4.20746 19.7148 4 19.3729 4 19V15.6966C2.22953 14.87 0 12.5452 0 8C0 4.74814 1.1071 2.6253 3.1009 1.39834Z"
            fill={props.fill}
        />
    </svg>
);

SupportChatIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default SupportChatIcon;
