import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowRightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M14.5859 12L8.29292 5.707C8.11076 5.5184 8.00997 5.26579 8.01225 5.0036C8.01452 4.7414 8.11969 4.49059 8.3051 4.30518C8.49051 4.11977 8.74132 4.0146 9.00352 4.01232C9.26571 4.01005 9.51832 4.11084 9.70692 4.293L16.3539 10.939C16.4933 11.0783 16.6039 11.2437 16.6793 11.4258C16.7548 11.6078 16.7936 11.8029 16.7936 12C16.7936 12.1971 16.7548 12.3922 16.6793 12.5742C16.6039 12.7563 16.4933 12.9217 16.3539 13.061L9.70692 19.707C9.51832 19.8892 9.26571 19.99 9.00352 19.9877C8.74132 19.9854 8.49051 19.8802 8.3051 19.6948C8.11969 19.5094 8.01452 19.2586 8.01224 18.9964C8.00997 18.7342 8.11076 18.4816 8.29292 18.293L14.5859 12Z"
            fill={props.fill}
        />
    </svg>
);

ArrowRightIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ArrowRightIcon;
