import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowTopIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M11.9999 9.414L5.70692 15.707C5.51832 15.8892 5.26571 15.99 5.00352 15.9877C4.74132 15.9854 4.49051 15.8802 4.3051 15.6948C4.11969 15.5094 4.01452 15.2586 4.01224 14.9964C4.00997 14.7342 4.11076 14.4816 4.29292 14.293L10.9389 7.646C11.0782 7.50661 11.2436 7.39603 11.4257 7.32059C11.6077 7.24515 11.8029 7.20632 11.9999 7.20632C12.197 7.20632 12.3921 7.24515 12.5742 7.32059C12.7562 7.39603 12.9216 7.50661 13.0609 7.646L19.7069 14.293C19.8891 14.4816 19.9899 14.7342 19.9876 14.9964C19.9853 15.2586 19.8801 15.5094 19.6947 15.6948C19.5093 15.8802 19.2585 15.9854 18.9963 15.9877C18.7341 15.99 18.4815 15.8892 18.2929 15.707L11.9999 9.414Z"
            fill={props.fill}
        />
    </svg>
);

ArrowTopIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ArrowTopIcon;
