import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BaggageNoSizeIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M16.3806 5H7.61935C6.19677 5 5 6.15556 5 7.57778V17.2779C5 18.2159 5.79582 19.3 6.64812 19.8199C6.87124 19.956 7.13448 20.0001 7.39583 20.0001C7.63105 20.0001 7.86366 20.0001 8.5 20.0001C9.47097 20.0001 10 20.0001 10 20.0001H11H13.5H14C14 20.0001 14.5516 20.0001 15.5 20.0001C16.471 20.0001 16.5 20.0001 16.5 20.0001H16.6125C16.8685 20.0001 17.1262 19.958 17.3461 19.8271C18.2144 19.3101 19 18.2203 19 17.2779V7.57778C19 6.15556 17.8032 5 16.3806 5ZM8.47742 1.64444C8.47742 1.28889 8.77097 1 9.13226 1H14.8903C15.2516 1 15.5452 1.28889 15.5452 1.64444V4H14.5V2.00006H9.5V3.00006V3.96117V4H8.47742V1.64444Z"
            fill={props.fill}
        />
        <mask
            id="979b53df__mask0_18006_4217"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={6}
            y={21}
            width={12}
            height={2}
        >
            <rect x={6} y={21} width={12} height={2} fill="#C4C4C4" />
        </mask>
        <g mask="url(#979b53df__mask0_18006_4217)">
            <circle cx={8.5} cy={21.5} r={1.5} fill={props.fill} />
            <circle cx={15.5} cy={21.5} r={1.5} fill={props.fill} />
        </g>
    </svg>
);

BaggageNoSizeIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default BaggageNoSizeIcon;
