import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BalconyIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M0 13.5C0 12.6716 0.671573 12 1.5 12H22.5C23.3284 12 24 12.6716 24 13.5C24 14.3284 23.3284 15 22.5 15H1.5C0.671573 15 0 14.3284 0 13.5Z"
            fill={props.fill}
        />
        <rect y={21} width={24} height={3} rx={1.5} fill={props.fill} />
        <mask id="8b49de56__path-3-inside-1_12635_20" fill="white">
            <rect x={3} y={1.5} width={18} height={13.5} rx={2} />
        </mask>
        <rect
            x={3}
            y={1.5}
            width={18}
            height={13.5}
            rx={2}
            stroke={props.fill}
            strokeWidth={6}
            mask="url(#8b49de56__path-3-inside-1_12635_20)"
        />
        <path d="M2.25 15H5.25V21H2.25V15Z" fill={props.fill} />
        <path d="M19 15H22V21H19V15Z" fill={props.fill} />
        <path d="M10.5 15L13.5 15V21H10.5V15Z" fill={props.fill} />
        <path d="M10.5 3H13.5V13.5H10.5V3Z" fill={props.fill} />
    </svg>
);

BalconyIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default BalconyIcon;
