import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CalendarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7 2C6.44772 2 6 2.44772 6 3V4.00141C5.03887 4.01522 4.66035 4.12994 4.27894 4.33392C3.87154 4.5518 3.5518 4.87154 3.33392 5.27894C3.11603 5.68635 3 6.09046 3 7.20486V17.7951C3 18.9095 3.11603 19.3137 3.33392 19.7211C3.5518 20.1285 3.87154 20.4482 4.27894 20.6661C4.68635 20.884 5.09046 21 6.20486 21H17.7951C18.9095 21 19.3137 20.884 19.7211 20.6661C20.1285 20.4482 20.4482 20.1285 20.6661 19.7211C20.884 19.3137 21 18.9095 21 17.7951V7.20486C21 6.09046 20.884 5.68635 20.6661 5.27894C20.4482 4.87154 20.1285 4.5518 19.7211 4.33392C19.3396 4.12994 18.9611 4.01522 18 4.00141V3C18 2.44772 17.5523 2 17 2C16.4477 2 16 2.44772 16 3V4H8V3C8 2.44772 7.55228 2 7 2ZM5 9V17.7951C5 18.2216 5.01899 18.4887 5.04897 18.644C5.06072 18.7048 5.06567 18.7183 5.09754 18.7779C5.12903 18.8367 5.16327 18.871 5.22214 18.9025C5.28173 18.9343 5.29517 18.9393 5.35599 18.951C5.51125 18.981 5.77844 19 6.20486 19H17.7951C18.2216 19 18.4887 18.981 18.644 18.951C18.7048 18.9393 18.7183 18.9343 18.7779 18.9025C18.8367 18.871 18.871 18.8367 18.9025 18.7779C18.9343 18.7183 18.9393 18.7048 18.951 18.644C18.981 18.4887 19 18.2216 19 17.7951L19.0044 9H5ZM13.75 13C13.3358 13 13 13.3358 13 13.75V16.25C13 16.6642 13.3358 17 13.75 17H16.25C16.6642 17 17 16.6642 17 16.25V13.75C17 13.3358 16.6642 13 16.25 13H13.75Z"
            fill={props.fill}
        />
    </svg>
);

CalendarIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default CalendarIcon;
