import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CallIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M8.99988 16.0001C2.81388 9.81308 3.10988 5.13408 5.93988 3.01208L6.56688 2.54508C6.72686 2.42737 6.90884 2.343 7.10205 2.29697C7.29525 2.25094 7.49573 2.24419 7.69159 2.27711C7.88746 2.31003 8.07471 2.38196 8.24224 2.48863C8.40978 2.5953 8.55418 2.73454 8.66688 2.89808L10.2459 5.17008C10.4572 5.47415 10.5485 5.84562 10.5024 6.213C10.4562 6.58039 10.2758 6.91772 9.99588 7.16008L8.47588 8.47408C8.09588 8.80308 7.90988 9.30208 8.08088 9.77508C8.39688 10.6551 9.16388 12.2081 10.9779 14.0211C12.7919 15.8351 14.3439 16.6021 15.2239 16.9191C15.6979 17.0891 16.1969 16.9041 16.5259 16.5231L17.8399 15.0051C18.0822 14.7251 18.4196 14.5447 18.787 14.4986C19.1543 14.4524 19.5258 14.5438 19.8299 14.7551L22.1059 16.3351C22.2693 16.4474 22.4084 16.5914 22.515 16.7586C22.6217 16.9257 22.6936 17.1126 22.7267 17.3081C22.7597 17.5036 22.7531 17.7038 22.7073 17.8967C22.6614 18.0896 22.5773 18.2713 22.4599 18.4311L21.9899 19.0641C19.8689 21.8921 15.1879 22.1871 8.99988 16.0001Z"
            fill={props.fill}
        />
    </svg>
);

CallIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default CallIcon;
